package com.yd.email.feign.response;

import lombok.Data;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class ApiEmailContactDetailResponse {

    /**
     * 邮箱联系人表主键ID
     */
    private Long id;

    /**
     * 收件人唯一业务ID（联系人唯一业务ID）
     */
    private String contactBizId;

    /**
     * 公司名称（保险公司等）
     */
    private String companyName;

    /**
     * 联系人姓名
     */
    private String name;

    /**
     * 联系人邮箱
     */
    private String email;

    /**
     * 分组名称
     */
    private String groupName;

    /**
     * 类型
     */
    private String type;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 关联抄送邮箱的列表
     */
    private List<String> ccEmailList;
}
