package com.yd.email.service.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class EmailContactImportDto {

    /**
     * 导入临时表唯一业务ID
     */
    private String importBizId;

    /**
     * 当前会话id（前端使用，用于查询。存于前端缓存）
     */
    private String sessionId;

    /**
     * 收件人邮箱（单个）
     */
    private String receiveEmail;

    /**
     * 导入数据的来源 0-选择联系人导入 1-excel导入联系人
     */
    private Integer source;

    @Builder.Default
    private Boolean isExcludeMy = false;
}
