package com.yd.email.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 发件人配置表（存储SMTP服务器配置信息）
 * </p>
 *
 * @author zxm
 * @since 2025-09-19
 */
@Getter
@Setter
@TableName("email_sender_config")
public class EmailSenderConfig implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 发件人唯一业务ID
     */
    @TableField("sender_biz_id")
    private String senderBizId;

    /**
     * 邮箱地址
     */
    @TableField("email")
    private String email;

    /**
     * 邮箱密码或授权码
     */
    @TableField("password")
    private String password;

    /**
     * 邮箱服务商唯一业务ID
     */
    @TableField("provider_biz_id")
    private String providerBizId;

    /**
     * 发件人显示名称（姓名/昵称）
     */
    @TableField("display_name")
    private String displayName;

    /**
     * 是否启用该配置: 0-否, 1-是（字典）
     */
    @TableField("active")
    private Integer active;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
