package com.yd.email.feign.client;

import com.yd.common.result.Result;
import com.yd.email.feign.fallback.ApiEmailProviderConfigFeignFallbackFactory;
import com.yd.email.feign.request.ApiEmailProviderConfigAddRequest;
import com.yd.email.feign.request.ApiEmailProviderConfigEditRequest;
import com.yd.email.feign.request.ApiEmailProviderConfigPageRequest;
import com.yd.email.feign.response.ApiEmailProviderConfigDetailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * 邮箱服务-SMTP邮箱服务商配置信息Feign客户端
 */
@FeignClient(name = "yd-email-api", fallbackFactory = ApiEmailProviderConfigFeignFallbackFactory.class)
public interface ApiEmailProviderConfigFeignClient {

    /**
     * 分页查询-邮箱服务商
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiEmailProviderConfigPageRequest request);

    /**
     * 添加-邮箱服务商
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiEmailProviderConfigAddRequest request);

    /**
     * 编辑-邮箱服务商
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiEmailProviderConfigEditRequest request);

    /**
     * 详情-邮箱服务商
     * @param providerBizId 邮箱服务商唯一业务ID
     * @return
     */
    @GetMapping("/detail")
    Result<ApiEmailProviderConfigDetailResponse> detail(@RequestParam(value = "providerBizId") String providerBizId);

    /**
     * 删除-邮箱服务商
     * @param providerBizId 邮箱服务商唯一业务ID
     * @return
     */
    @DeleteMapping("/del")
    Result del(@RequestParam(value = "providerBizId") String providerBizId);
}
