package com.yd.email.feign.response;

import lombok.Data;

import java.time.LocalDateTime;

/**
 * 详情-邮箱发件人出参
 */
@Data
public class ApiEmailSenderConfigDetailResponse {

    /**
     * 邮箱发件人表主键ID
     */
    private Long id;

    /**
     * 发件人唯一业务ID
     */
    private String senderBizId;

    /**
     * 邮箱地址
     */
    private String email;

    /**
     * 邮箱密码或授权码
     */
    private String password;

    /**
     * 邮箱服务商唯一业务ID
     */
    private String providerBizId;

    /**
     * 邮箱服务商名称
     */
    private String providerName;

    /**
     * 发件人显示名称（姓名/昵称）
     */
    private String displayName;

    /**
     * 是否启用该配置: 0-否, 1-是（字典）
     */
    private Integer active;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

}
