package com.yd.email.feign.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

@Slf4j
public class StringUtil {

    /**
     * 替换邮件模板内容的变量占位符
     * @param content 例：”{{name}} 你好，很高兴认识你。你今年{{age}}岁是吧“
     * @param variables 变量和收件人数据json串（导入变量excel时插入）
     *                  [{cn_key: 中文变量字段名,en_key: 英文变量字段名,content: 占位符内容}]
     *                  例：[{cn_key: '姓名',en_key: ’name‘,content: '张山'},{cn_key: '年龄',en_key: ’age‘,content: '28'}]
     * @return
     */
    public static String replacePlaceholders(String content, String variables) {
        // 解析 JSON 字符串
        JSONArray variablesArray = JSON.parseArray(variables);
        String result = content;
        log.info("JSONArray variablesArray：{}",JSON.toJSONString(variablesArray));
        log.info("result：{}",result);
        // 遍历变量数组，逐个替换占位符
        for (int i = 0; i < variablesArray.size(); i++) {
            JSONObject variable = variablesArray.getJSONObject(i);
            String enKey = variable.getString("en_key");
            String value = variable.getString("content");
            log.info("JSONObject variable：{}",JSON.toJSONString(variable));
            log.info("variable.getString(\"en_key\")：{}",enKey);
            log.info("variable.getString(\"content\")：{}",value);
            // 替换 {{en_key}} 为对应的值
            result = result.replace("{{" + enKey + "}}", value);
            log.info("result.replace：{}",result);
        }

        return result;
    }

    /**
     * 检测内容是否有通用三个变量：通用变量：收件人姓名：{{name}}、收件人称谓： {{appellation}}、公司：{{compantName}}
     * @param content
     * @return
     */
    public static boolean hasTyVariables(String content) {
        if (StringUtils.isBlank(content)) {
            return false;
        }
        return (content.contains("{{name}}") || content.contains("{{appellation}}") || content.contains("{{compantName}}"));
    }

    /**
     * 检测内容是否有占位符
     * @param content
     * @return
     */
    public static boolean hasPlaceholders(String content) {
        if (content == null) {
            return false;
        }
        // 匹配 {{任意内容}} 的模式
        String pattern = "\\{\\{[^}]*\\}\\}";
        return content.matches(".*" + pattern + ".*");
    }

    /**
     * 更严格的版本，要求{{}}之间有内容
     * @param content
     * @return
     */
    public static boolean hasValidPlaceholders(String content) {
        if (content == null) {
            return false;
        }
        String pattern = "\\{\\{\\w+\\}\\}"; // 只匹配字母数字下划线
        return content.matches(".*" + pattern + ".*");
    }

    public static boolean hasPlaceholdersSimple(String content) {
        if (content == null) {
            return false;
        }
        return content.contains("{{") && content.contains("}}");
    }
}
