package com.yd.email.feign.response;

import lombok.Data;

import java.time.LocalDateTime;

@Data
public class ApiEmailTaskPageResponse {

    /**
     * 邮件任务主表主键ID
     */
    private Long id;

    /**
     * 邮件任务唯一业务ID
     */
    private String taskBizId;

    /**
     * 任务名称
     */
    private String taskName;

    /**
     * 关联发件人唯一业务ID
     */
    private String senderBizId;

    /**
     * 发件人邮箱
     */
    private String sendEmail;

    /**
     * 收件人邮箱（多个用分号分隔）
     */
    private String receiveEmails;

    /**
     * 邮件主题
     */
    private String subject;

    /**
     * 任务状态：PENDING-待发送, SENDING-发送中, COMPLETED-已完成, FAILED-发送失败, CANCELLED-已取消
     */
    private String status;

    /**
     * 计划发送时间（为空表示立即发送，不为空表示定时发送）
     */
    private LocalDateTime scheduleTime;

    /**
     * 实际发送时间（发送成功的时间）
     */
    private LocalDateTime sendTime;
}
