package com.yd.email.feign.client;

import com.yd.common.result.Result;
import com.yd.email.feign.fallback.ApiEmailFileFeignFallbackFactory;
import com.yd.email.feign.request.ApiExportVariableExcelRequest;
import com.yd.email.feign.request.ApiImportVariableExcelRequest;
import com.yd.email.feign.response.ApiExportVariableExcelResponse;
import com.yd.email.feign.response.ApiImportVariableExcelResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

/**
 * 邮箱服务-邮件文件信息Feign客户端
 */
@FeignClient(name = "yd-email-api", fallbackFactory = ApiEmailFileFeignFallbackFactory.class)
public interface ApiEmailFileFeignClient {

    /**
     * 导出-变量excel
     * @param request
     * @return
     */
    @PostMapping("/export/excel/variable")
    Result<ApiExportVariableExcelResponse> exportVariableExcel(@Validated @RequestBody ApiExportVariableExcelRequest request);

    /**
     * 导入-变量excel
     * @param file
     * @param request
     * @return
     */
    @PostMapping(value = "/import/excel/variable", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    Result<ApiImportVariableExcelResponse> importVariableExcel(@RequestParam("file") MultipartFile file,
                                                               @Validated ApiImportVariableExcelRequest request);
}
