package com.yd.email.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.email.feign.request.ApiEmailVariableGroupPageRequest;
import com.yd.email.feign.response.ApiEmailVariableGroupPageResponse;
import com.yd.email.service.dto.EmailVariableGroupDto;
import com.yd.email.service.model.EmailVariable;
import com.yd.email.service.model.EmailVariableGroup;
import com.yd.email.service.dao.EmailVariableGroupMapper;
import com.yd.email.service.service.IEmailVariableGroupService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 变量分组表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-09-22
 */
@Service
public class EmailVariableGroupServiceImpl extends ServiceImpl<EmailVariableGroupMapper, EmailVariableGroup> implements IEmailVariableGroupService {

    @Override
    public IPage<ApiEmailVariableGroupPageResponse> page(Page<ApiEmailVariableGroupPageResponse> page,
                                                         ApiEmailVariableGroupPageRequest request) {
        return baseMapper.page(page,request);
    }

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<EmailVariableGroup> queryList(EmailVariableGroupDto dto) {
        List<EmailVariableGroup> list = baseMapper.selectList(new LambdaQueryWrapper<EmailVariableGroup>()
                .eq(StringUtils.isNotBlank(dto.getVariableGroupBizId()) && !dto.getIsExcludeMy(),EmailVariableGroup::getVariableGroupBizId,dto.getVariableGroupBizId())
                .eq(StringUtils.isNotBlank(dto.getGroupName()),EmailVariableGroup::getGroupName,dto.getGroupName())
                .ne(dto.getIsExcludeMy(),EmailVariableGroup::getVariableGroupBizId,dto.getVariableGroupBizId())
        );
        return list;
    }

    /**
     * 查询单个对象
     * @param variableGroupBizId
     * @return
     */
    @Override
    public EmailVariableGroup queryOne(String variableGroupBizId) {
        return this.getOne(new LambdaQueryWrapper<EmailVariableGroup>()
                .eq(EmailVariableGroup::getVariableGroupBizId,variableGroupBizId));
    }

}
