package com.yd.email.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 邮件联系人导入临时表
 * </p>
 *
 * @author zxm
 * @since 2025-09-23
 */
@Getter
@Setter
@TableName("email_contact_import")
public class EmailContactImport implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 导入临时表唯一业务ID
     */
    @TableField("import_biz_id")
    private String importBizId;

    /**
     * 当前会话id（前端使用，用于查询。存于前端缓存）
     */
    @TableField("session_id")
    private String sessionId;

    /**
     * 收件人唯一业务ID（联系人唯一业务ID，导入excel无值，选择联系人有值）
     */
    @TableField("contact_biz_id")
    private String contactBizId;

    /**
     * 收件人邮箱（单个）
     */
    @TableField("receive_email")
    private String receiveEmail;

    /**
     * 抄送人邮箱（多个用分号分隔）
     */
    @TableField("cc_email")
    private String ccEmail;

    /**
     * 密送人邮箱（多个用分号分隔）
     */
    @TableField("bcc_email")
    private String bccEmail;

    /**
     * 导入数据的来源 0-选择联系人导入 1-excel导入联系人
     */
    @TableField("source")
    private Integer source;

    /**
     * 变量和收件人数据json串（导入变量excel时插入）
     * [{cn_key: 中文变量字段名,en_key: 英文变量字段名,content: 占位符内容}]
     */
    @TableField("variables")
    private String variables;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
