package com.yd.email.service.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.email.feign.request.ApiEmailProviderConfigPageRequest;
import com.yd.email.feign.response.ApiEmailProviderConfigPageResponse;
import com.yd.email.service.dto.EmailProviderConfigDto;
import com.yd.email.service.model.EmailProviderConfig;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
 * <p>
 * SMTP邮箱服务商配置表（存储不同邮箱服务商的SMTP配置信息） 服务类
 * </p>
 *
 * @author zxm
 * @since 2025-09-19
 */
public interface IEmailProviderConfigService extends IService<EmailProviderConfig> {

    IPage<ApiEmailProviderConfigPageResponse> page(Page<ApiEmailProviderConfigPageResponse> page,
                                                   ApiEmailProviderConfigPageRequest request);

    EmailProviderConfig queryOne(String providerBizId);

    List<EmailProviderConfig> queryList(EmailProviderConfigDto dto);
}
