package com.yd.email.service.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.email.feign.request.ApiEmailSenderConfigPageRequest;
import com.yd.email.feign.response.ApiEmailSenderConfigPageResponse;
import com.yd.email.service.dto.EmailSenderConfigDto;
import com.yd.email.service.model.EmailSenderConfig;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
 * <p>
 * 发件人配置表（存储SMTP服务器配置信息） 服务类
 * </p>
 *
 * @author zxm
 * @since 2025-09-19
 */
public interface IEmailSenderConfigService extends IService<EmailSenderConfig> {

    IPage<ApiEmailSenderConfigPageResponse> page(Page<ApiEmailSenderConfigPageResponse> page,
                                                 ApiEmailSenderConfigPageRequest request);

    List<EmailSenderConfig> queryList(EmailSenderConfigDto dto);

    EmailSenderConfig queryOne(String senderBizId);
}
