package com.yd.insurance.base.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.insurance.base.api.service.ApiInsuranceAdditionalProductService;
import com.yd.insurance.base.feign.client.ApiInsuranceAdditionalProductFeignClient;
import com.yd.insurance.base.feign.request.ApiInsuranceAdditionalProductAddRequest;
import com.yd.insurance.base.feign.request.ApiInsuranceAdditionalProductEditRequest;
import com.yd.insurance.base.feign.request.ApiInsuranceAdditionalProductPageRequest;
import com.yd.insurance.base.feign.response.ApiInsuranceAdditionalProductDetailResponse;
import com.yd.insurance.base.feign.response.ApiInsuranceAdditionalProductPageResponse;
import com.yd.insurance.base.feign.response.ApiInsuranceProductPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 保险附加产品基础信息
 *
 * @author zxm
 * @since 2025-08-29
 */
@RestController
@RequestMapping("/insuranceAdditionalProduct")
@Validated
public class ApiInsuranceAdditionalProductController implements ApiInsuranceAdditionalProductFeignClient {

    @Autowired
    private ApiInsuranceAdditionalProductService apiInsuranceAdditionalProductService;

    /**
     * 保险附加产品分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiInsuranceAdditionalProductPageResponse>> page(ApiInsuranceAdditionalProductPageRequest request) {
        return apiInsuranceAdditionalProductService.page(request);
    }

    /**
     *
     * 获取保险附加产品详情
     * @param additionalProductBizId 保险附加产品唯一标识(业务ID)
     * @return
     */
    @Override
    public Result<ApiInsuranceAdditionalProductDetailResponse> detail(String additionalProductBizId) {
        return apiInsuranceAdditionalProductService.detail(additionalProductBizId);
    }

    /**
     * 添加保险附加产品
     * @param request
     * @return
     */
    @Override
    public Result add(ApiInsuranceAdditionalProductAddRequest request) {
        return apiInsuranceAdditionalProductService.add(request);
    }

    /**
     * 编辑保险附加产品
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiInsuranceAdditionalProductEditRequest request) {
        return apiInsuranceAdditionalProductService.edit(request);
    }

    /**
     * 删除保险附加产品（逻辑删除）
     * @param additionalProductBizId 保险附加产品唯一标识(业务ID)
     * @return
     */
    @Override
    public Result del(String additionalProductBizId) {
        return apiInsuranceAdditionalProductService.del(additionalProductBizId);
    }

    /**
     * 编辑保险附加产品状态
     * @param additionalProductBizId 保险附加产品唯一标识(业务ID)
     * @param status '保险附加产品状态：0=下架，1=在售'
     * @return
     */
    @Override
    public Result editStatus(String additionalProductBizId,Integer status) {
        return apiInsuranceAdditionalProductService.editStatus(additionalProductBizId,status);
    }
}
