package com.yd.insurance.base.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.common.result.Result;
import com.yd.insurance.base.api.service.ApiInsuranceCategoryService;
import com.yd.insurance.base.feign.request.insurancecategory.ApiInsuranceCategoryAddRequest;
import com.yd.insurance.base.feign.request.insurancecategory.ApiInsuranceCategoryPageRequest;
import com.yd.insurance.base.feign.response.insurancecategory.ApiInsuranceCategoryDetailResponse;
import com.yd.insurance.base.feign.response.insurancecategory.ApiInsuranceCategoryEditRequest;
import com.yd.insurance.base.feign.response.insurancecategory.ApiInsuranceCategoryPageResponse;
import com.yd.insurance.base.service.service.IInsuranceCategoryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class ApiInsuranceCategoryServiceImpl implements ApiInsuranceCategoryService {

    @Autowired
    private IInsuranceCategoryService iInsuranceCategoryService;

    /**
     * 分页列表查询-保险险种信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiInsuranceCategoryPageResponse>> page(ApiInsuranceCategoryPageRequest request) {
        Page<ApiInsuranceCategoryPageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiInsuranceCategoryPageResponse> iPage = iInsuranceCategoryService.page(page, request);
        return Result.success(iPage);
    }

    /**
     * 详情-保险险种信息
     * @param insuranceCategoryBizId 保险险种表唯一业务ID
     * @return
     */
    @Override
    public Result<ApiInsuranceCategoryDetailResponse> detail(String insuranceCategoryBizId) {

        return null;
    }

    /**
     * 添加-保险险种信息
     * @param request
     * @return
     */
    @Override
    public Result add(ApiInsuranceCategoryAddRequest request) {
        return null;
    }

    /**
     * 编辑-保险险种信息
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiInsuranceCategoryEditRequest request) {
        return null;
    }

    /**
     * 删除-保险险种信息
     * @param insuranceCategoryBizId 保险险种表唯一业务ID
     * @return
     */
    @Override
    public Result del(String insuranceCategoryBizId) {
        return null;
    }

    /**
     * 编辑-保险险种信息状态
     * @param insuranceCategoryBizId 保险险种表唯一业务ID
     * @param status 状态(0:停用 1:启用)
     * @return
     */
    @Override
    public Result editStatus(String insuranceCategoryBizId, String status) {
        return null;
    }

}
