package com.yd.insurance.base.feign.fallback;

import com.yd.common.result.Result;
import com.yd.insurance.base.feign.client.ApiRelProductAnnouncementFeignClient;
import com.yd.insurance.base.feign.request.ApiQueryRatioRequest;
import com.yd.insurance.base.feign.response.ApiQueryRatioResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 保险基础数据服务-产品和公告比例关系信息Feign降级处理
 */
@Slf4j
@Component
public class ApiRelProductAnnouncementFeignFallbackFactory implements FallbackFactory<ApiRelProductAnnouncementFeignClient> {
    @Override
    public ApiRelProductAnnouncementFeignClient create(Throwable cause) {
        return new ApiRelProductAnnouncementFeignClient() {
            @Override
            public Result<ApiQueryRatioResponse> queryRatio(ApiQueryRatioRequest request) {
                return null;
            }
        };
    }
}
