package com.yd.insurance.base.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.insurance.base.service.dto.RelInsuranceProductDeptDto;
import com.yd.insurance.base.service.model.RelInsuranceProductDept;
import com.yd.insurance.base.service.dao.RelInsuranceProductDeptMapper;
import com.yd.insurance.base.service.service.IRelInsuranceProductDeptService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yd.user.service.model.RelTenantDept;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 保险产品-部门关系表（多对多关系） 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-08-27
 */

@Slf4j
@Primary
@Service
public class RelInsuranceProductDeptServiceImpl extends ServiceImpl<RelInsuranceProductDeptMapper, RelInsuranceProductDept> implements IRelInsuranceProductDeptService {

    /**
     * 根据类型和产品id删除产品部门关系
     * @param type
     * @param productBizId
     * @return
     */
    @Override
    public Boolean removeByProductBizIdAndType(Integer type, String productBizId) {
        return this.remove(new LambdaQueryWrapper<RelInsuranceProductDept>()
                .eq(RelInsuranceProductDept::getType,type)
                .eq(RelInsuranceProductDept::getProductBizId,productBizId)
        );
    }

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<RelInsuranceProductDept> queryList(RelInsuranceProductDeptDto dto) {
        List<RelInsuranceProductDept> list = baseMapper.selectList(new LambdaQueryWrapper<RelInsuranceProductDept>()
                .eq(StringUtils.isNotBlank(dto.getProductBizId()),RelInsuranceProductDept::getProductBizId,dto.getProductBizId())
                .eq(!Objects.isNull(dto.getType()),RelInsuranceProductDept::getType,dto.getType())
        );
        return list;
    }

}
