package com.yd.insurance.base.api.controller;

import com.yd.common.result.Result;
import com.yd.insurance.base.api.service.ApiRelProductAnnouncementService;
import com.yd.insurance.base.feign.client.ApiRelProductAnnouncementFeignClient;
import com.yd.insurance.base.feign.request.ApiQueryRatioRequest;
import com.yd.insurance.base.feign.response.ApiQueryRatioResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 产品和公告比例关系信息
 *
 * @author zxm
 * @since 2025-10-28
 */
@RestController
@RequestMapping("/relProductAnnouncement")
@Validated
public class ApiRelProductAnnouncementController implements ApiRelProductAnnouncementFeignClient {

    @Autowired
    private ApiRelProductAnnouncementService apiRelProductAnnouncementService;

    /**
     * 查询-产品公告比例
     * @param request
     * @return
     */
    @Override
    public Result<ApiQueryRatioResponse> queryRatio(ApiQueryRatioRequest request) {
        return apiRelProductAnnouncementService.queryRatio(request);
    }
}
