package com.yd.insurance.base.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yd.insurance.base.feign.request.usersignexpand.ApiUserSignExpandPageRequest;
import com.yd.insurance.base.feign.response.usersignexpand.ApiUserSignExpandPageResponse;
import com.yd.insurance.base.service.dao.UserSignExpandMapper;
import com.yd.insurance.base.service.model.UserSignExpand;
import com.yd.insurance.base.service.service.IUserSignExpandService;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 系统用户-签单用户扩展表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-12-19
 */
@Service
public class UserSignExpandServiceImpl extends ServiceImpl<UserSignExpandMapper, UserSignExpand> implements IUserSignExpandService {

    @Override
    public IPage<ApiUserSignExpandPageResponse> page(Page<ApiUserSignExpandPageResponse> page,
                                                     ApiUserSignExpandPageRequest request) {
        return baseMapper.page(page,request);
    }

    @Override
    public UserSignExpand queryOne(String userSignBizId) {
        return this.getOne(new LambdaQueryWrapper<UserSignExpand>().eq(UserSignExpand::getUserBizId,userSignBizId));
    }
}
