package com.yd.insurance.base.feign.dto;

import lombok.Data;
import java.math.BigDecimal;

/**
 * 产品对应的公告比例对象
 */
@Data
public class ApiProductRatioDto {

    /**
     * 保险产品唯一业务ID
     */
    private String productBizId;

    /**
     * 保险产品名称
     */
    private String productName;

    /**
     * 保险产品代码
     */
    private String productCode;

    /**
     * 公告比例
     */
    private BigDecimal ratio;

    /**
     * 当前佣金期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年。。)
     */
    private Integer commissionPeriod;
}
