package com.yd.insurance.base.feign.client;

import com.yd.common.result.Result;
import com.yd.insurance.base.feign.fallback.ApiInsuranceProductFeignFallbackFactory;
import com.yd.insurance.base.feign.request.ApiInsuranceProductAddRequest;
import com.yd.insurance.base.feign.request.ApiInsuranceProductEditRequest;
import com.yd.insurance.base.feign.request.ApiInsuranceProductPageRequest;
import com.yd.insurance.base.feign.response.ApiInsuranceProductDetailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 保险基础数据服务-保险产品基础信息Feign客户端
 */
@FeignClient(name = "yd-insurance-base-api", fallbackFactory = ApiInsuranceProductFeignFallbackFactory.class)
public interface ApiInsuranceProductFeignClient {

    /**
     * 保险产品分页查询
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiInsuranceProductPageRequest request);

    /**
     * 获取保险产品详情
     * @param productBizId 保险产品唯一标识(业务ID)
     * @return
     */
    @GetMapping("/detail")
    Result<ApiInsuranceProductDetailResponse> detail(@NotBlank(message = "保险产品唯一标识(业务ID)不能为空") @RequestParam(value = "productBizId") String productBizId);

    /**
     * 添加保险产品
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiInsuranceProductAddRequest request);

    /**
     * 编辑保险产品
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiInsuranceProductEditRequest request);


    /**
     * 删除保险产品（逻辑删除）
     * @param productBizId 保险产品唯一标识(业务ID)
     * @return
     */
    @DeleteMapping("/del")
    Result del(@RequestParam(value = "productBizId") String productBizId);

    /**
     * 编辑保险产品状态
     * @param productBizId 保险产品唯一标识(业务ID)
     * @param status '保险产品状态：0=下架，1=在售'
     * @return
     */
    @PatchMapping("/edit/status")
    Result editStatus(@NotBlank(message = "保险产品唯一标识(业务ID)不能为空") @RequestParam(value = "productBizId") String productBizId,
                      @NotNull(message = "状态不能为空") @RequestParam(value = "status") Integer status);
}
