package com.yd.insurance.base.feign.fallback;

import com.yd.common.result.Result;
import com.yd.insurance.base.feign.client.ApiRelTenantInsuranceProductFeignClient;
import com.yd.insurance.base.feign.request.ApiRelTenantInsuranceProductListAddRequest;
import com.yd.insurance.base.feign.request.ApiRelTenantInsuranceProductListPageRequest;
import com.yd.insurance.base.feign.request.ApiRelTenantInsuranceProductSelectPageRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 保险基础数据服务-租户保险产品关系信息Feign降级处理
 */
@Slf4j
@Component
public class ApiRelTenantInsuranceProductFeignFallbackFactory implements FallbackFactory<ApiRelTenantInsuranceProductFeignClient> {
    @Override
    public ApiRelTenantInsuranceProductFeignClient create(Throwable cause) {
        return new ApiRelTenantInsuranceProductFeignClient() {
            @Override
            public Result page(ApiRelTenantInsuranceProductListPageRequest request) {
                return null;
            }

            @Override
            public Result addProductList(ApiRelTenantInsuranceProductListAddRequest request) {
                return null;
            }

            @Override
            public Result del(Long id) {
                return null;
            }

            @Override
            public Result selectProductPage(ApiRelTenantInsuranceProductSelectPageRequest request) {
                return null;
            }
        };
    }
}
