package com.yd.insurance.base.feign.fallback.insurancecategory;

import com.yd.common.result.Result;
import com.yd.insurance.base.feign.client.insurancecategory.ApiInsuranceCategoryFeignClient;
import com.yd.insurance.base.feign.request.insurancecategory.ApiInsuranceCategoryAddRequest;
import com.yd.insurance.base.feign.request.insurancecategory.ApiInsuranceCategoryPageRequest;
import com.yd.insurance.base.feign.response.insurancecategory.ApiInsuranceCategoryDetailResponse;
import com.yd.insurance.base.feign.response.insurancecategory.ApiInsuranceCategoryEditRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 保险险种信息Feign降级处理
 */
@Slf4j
@Component
public class ApiInsuranceCategoryFeignFallbackFactory implements FallbackFactory<ApiInsuranceCategoryFeignClient> {
    @Override
    public ApiInsuranceCategoryFeignClient create(Throwable cause) {
        return new ApiInsuranceCategoryFeignClient() {
            @Override
            public Result page(ApiInsuranceCategoryPageRequest request) {
                return null;
            }

            @Override
            public Result<ApiInsuranceCategoryDetailResponse> detail(String insuranceCategoryBizId) {
                return null;
            }

            @Override
            public Result add(ApiInsuranceCategoryAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiInsuranceCategoryEditRequest request) {
                return null;
            }

            @Override
            public Result del(String insuranceCategoryBizId) {
                return null;
            }

            @Override
            public Result editStatus(String insuranceCategoryBizId,String status) {
                return null;
            }
        };
    }
}
