package com.yd.insurance.base.service.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.insurance.base.feign.request.ApiRelTenantInsuranceProductListPageRequest;
import com.yd.insurance.base.feign.request.ApiRelTenantInsuranceProductSelectPageRequest;
import com.yd.insurance.base.feign.response.ApiRelTenantInsuranceProductListPageResponse;
import com.yd.insurance.base.feign.response.ApiRelTenantInsuranceProductSelectPageResponse;
import com.yd.insurance.base.service.model.RelTenantInsuranceProduct;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

/**
 * <p>
 * 租户-保险产品关系表 Mapper 接口
 * </p>
 *
 * @author zxm
 * @since 2025-08-25
 */
public interface RelTenantInsuranceProductMapper extends BaseMapper<RelTenantInsuranceProduct> {

    IPage<ApiRelTenantInsuranceProductListPageResponse> page(@Param("page") Page<ApiRelTenantInsuranceProductListPageResponse> page,
                                                             @Param("request") ApiRelTenantInsuranceProductListPageRequest request);

    IPage<ApiRelTenantInsuranceProductSelectPageResponse> selectProductPage(@Param("page") Page<ApiRelTenantInsuranceProductSelectPageResponse> page,
                                                                            @Param("request") ApiRelTenantInsuranceProductSelectPageRequest request);
}
