package com.yd.insurance.base.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.insurance.base.api.service.ApiInsuranceCompanyService;
import com.yd.insurance.base.feign.client.insurancecompany.ApiInsuranceCompanyFeignClient;
import com.yd.insurance.base.feign.request.insurancecompany.ApiInsuranceCompanyAddRequest;
import com.yd.insurance.base.feign.request.insurancecompany.ApiInsuranceCompanyEditRequest;
import com.yd.insurance.base.feign.request.insurancecompany.ApiInsuranceCompanyPageRequest;
import com.yd.insurance.base.feign.response.insurancecompany.ApiInsuranceCompanyDetailResponse;
import com.yd.insurance.base.feign.response.insurancecompany.ApiInsuranceCompanyPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 保险公司信息
 *
 * @author zxm
 * @since 2025-12-22
 */
@RestController
@RequestMapping("/insuranceCompany")
@Validated
public class ApiInsuranceCompanyController implements ApiInsuranceCompanyFeignClient {

    @Autowired
    private ApiInsuranceCompanyService apiInsuranceCompanyService;

    /**
     * 分页列表查询-保险公司信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiInsuranceCompanyPageResponse>> page(ApiInsuranceCompanyPageRequest request) {
        return apiInsuranceCompanyService.page(request);
    }

    /**
     * 详情-保险公司信息
     * @param insuranceCompanyBizId 保险公司唯一业务ID
     * @return
     */
    @Override
    public Result<ApiInsuranceCompanyDetailResponse> detail(String insuranceCompanyBizId) {
        return apiInsuranceCompanyService.detail(insuranceCompanyBizId);
    }

    /**
     * 添加-保险公司信息
     * @param request
     * @return
     */
    @Override
    public Result add(ApiInsuranceCompanyAddRequest request) {
        return apiInsuranceCompanyService.add(request);
    }

    /**
     * 编辑-保险公司信息
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiInsuranceCompanyEditRequest request) {
        return apiInsuranceCompanyService.edit(request);
    }

    /**
     * 删除-保险公司信息 TODO
     * @param insuranceCompanyBizId 保险公司唯一业务ID
     * @return
     */
    @Override
    public Result del(String insuranceCompanyBizId) {
        return apiInsuranceCompanyService.del(insuranceCompanyBizId);
    }

    /**
     * 编辑-保险公司信息合作状态
     * @param insuranceCompanyBizId 保险公司唯一业务ID
     * @param cooperationStatus 合作状态（合作中、已终止、未合作）
     * @return
     */
    @Override
    public Result editStatus(String insuranceCompanyBizId, String cooperationStatus) {
        return apiInsuranceCompanyService.editStatus(insuranceCompanyBizId,cooperationStatus);
    }
}
