package com.yd.insurance.base.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.insurance.base.api.service.ApiInsuranceReconciliationCompanyService;
import com.yd.insurance.base.feign.client.insurancereconciliationcompany.ApiInsuranceReconciliationCompanyFeignClient;
import com.yd.insurance.base.feign.request.insurancereconciliationcompany.ApiInsuranceReconciliationCompanyAddRequest;
import com.yd.insurance.base.feign.request.insurancereconciliationcompany.ApiInsuranceReconciliationCompanyEditRequest;
import com.yd.insurance.base.feign.request.insurancereconciliationcompany.ApiInsuranceReconciliationCompanyPageRequest;
import com.yd.insurance.base.feign.response.insurancereconciliationcompany.ApiInsuranceReconciliationCompanyDetailResponse;
import com.yd.insurance.base.feign.response.insurancereconciliationcompany.ApiInsuranceReconciliationCompanyPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 保险对账公司信息
 *
 * @author zxm
 * @since 2025-12-23
 */
@RestController
@RequestMapping("/insuranceReconciliationCompany")
@Validated
public class ApiInsuranceReconciliationCompanyController implements ApiInsuranceReconciliationCompanyFeignClient {

    @Autowired
    private ApiInsuranceReconciliationCompanyService apiInsuranceReconciliationCompanyService;

    /**
     * 分页列表查询-保险对账公司信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiInsuranceReconciliationCompanyPageResponse>> page(ApiInsuranceReconciliationCompanyPageRequest request) {
        return apiInsuranceReconciliationCompanyService.page(request);
    }

    /**
     * 详情-保险对账公司信息
     * @param reconciliationCompanyBizId 保险对账公司唯一业务ID
     * @return
     */
    @Override
    public Result<ApiInsuranceReconciliationCompanyDetailResponse> detail(String reconciliationCompanyBizId) {
        return apiInsuranceReconciliationCompanyService.detail(reconciliationCompanyBizId);
    }

    /**
     * 添加-保险对账公司信息
     * @param request
     * @return
     */
    @Override
    public Result add(ApiInsuranceReconciliationCompanyAddRequest request) {
        return apiInsuranceReconciliationCompanyService.add(request);
    }

    /**
     * 编辑-保险对账公司信息
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiInsuranceReconciliationCompanyEditRequest request) {
        return apiInsuranceReconciliationCompanyService.edit(request);
    }

    /**
     * 删除-保险对账公司信息
     * @param reconciliationCompanyBizId 保险对账公司唯一业务ID
     * @return
     */
    @Override
    public Result del(String reconciliationCompanyBizId) {
        return apiInsuranceReconciliationCompanyService.del(reconciliationCompanyBizId);
    }

    /**
     * 编辑-保险对账公司信息状态
     * @param reconciliationCompanyBizId 保险对账公司唯一业务ID
     * @param status 状态(0:停用 1:启用)
     * @return
     */
    @Override
    public Result editStatus(String reconciliationCompanyBizId, String status) {
        return apiInsuranceReconciliationCompanyService.editStatus(reconciliationCompanyBizId,status);
    }

}
