package com.yd.insurance.base.feign.fallback;

import com.yd.common.result.Result;
import com.yd.insurance.base.feign.client.ApiInsuranceProductFeignClient;
import com.yd.insurance.base.feign.request.ApiInsuranceProductAddRequest;
import com.yd.insurance.base.feign.request.ApiInsuranceProductEditRequest;
import com.yd.insurance.base.feign.request.ApiInsuranceProductPageRequest;
import com.yd.insurance.base.feign.response.ApiInsuranceProductDetailResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 保险基础数据服务-保险产品基础信息Feign降级处理
 */
@Slf4j
@Component
public class ApiInsuranceProductFeignFallbackFactory implements FallbackFactory<ApiInsuranceProductFeignClient> {
    @Override
    public ApiInsuranceProductFeignClient create(Throwable cause) {
        return new ApiInsuranceProductFeignClient() {
            @Override
            public Result page(ApiInsuranceProductPageRequest request) {
                return null;
            }

            @Override
            public Result<ApiInsuranceProductDetailResponse> detail(String productBizId) {
                return null;
            }

            @Override
            public Result add(ApiInsuranceProductAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiInsuranceProductEditRequest request) {
                return null;
            }

            @Override
            public Result del(String productBizId) {
                return null;
            }

            @Override
            public Result editStatus(String productBizId,Integer status) {
                return null;
            }
        };
    }
}
