package com.yd.insurance.base.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.insurance.base.api.service.ApiInsuranceProductService;
import com.yd.insurance.base.feign.client.ApiInsuranceProductFeignClient;
import com.yd.insurance.base.feign.request.ApiInsuranceProductAddRequest;
import com.yd.insurance.base.feign.request.ApiInsuranceProductEditRequest;
import com.yd.insurance.base.feign.request.ApiInsuranceProductPageRequest;
import com.yd.insurance.base.feign.response.ApiInsuranceProductDetailResponse;
import com.yd.insurance.base.feign.response.ApiInsuranceProductPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 保险产品基础信息
 *
 * @author zxm
 * @since 2025-08-25
 */
@RestController
@RequestMapping("/insuranceProduct")
@Validated
public class ApiInsuranceProductController implements ApiInsuranceProductFeignClient {

    @Autowired
    private ApiInsuranceProductService apiInsuranceProductService;

    /**
     * 保险产品分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiInsuranceProductPageResponse>> page(ApiInsuranceProductPageRequest request) {
        return apiInsuranceProductService.page(request);
    }

    /**
     * 获取保险产品详情
     * @param productBizId 保险产品唯一标识(业务ID)
     * @return
     */
    @Override
    public Result<ApiInsuranceProductDetailResponse> detail(String productBizId) {
        return apiInsuranceProductService.detail(productBizId);
    }

    /**
     * 添加保险产品
     * @param request
     * @return
     */
    @Override
    public Result add(ApiInsuranceProductAddRequest request) {
        return apiInsuranceProductService.add(request);
    }

    /**
     * 编辑保险产品
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiInsuranceProductEditRequest request) {
        return apiInsuranceProductService.edit(request);
    }

    /**
     * 删除保险产品（逻辑删除） TODO
     * @param productBizId 保险产品唯一标识(业务ID)
     * @return
     */
    @Override
    public Result del(String productBizId) {
        return apiInsuranceProductService.del(productBizId);
    }

    /**
     * 编辑保险产品状态
     * @param productBizId 保险产品唯一标识(业务ID)
     * @param status '保险产品状态：0=下架，1=在售'
     * @return
     */
    @Override
    public Result editStatus(String productBizId,Integer status) {
        return apiInsuranceProductService.editStatus(productBizId,status);
    }
}
