package com.yd.insurance.base.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.insurance.base.api.service.ApiRelTenantInsuranceProductService;
import com.yd.insurance.base.feign.client.ApiRelTenantInsuranceProductFeignClient;
import com.yd.insurance.base.feign.request.ApiRelTenantInsuranceProductListAddRequest;
import com.yd.insurance.base.feign.request.ApiRelTenantInsuranceProductListPageRequest;
import com.yd.insurance.base.feign.request.ApiRelTenantInsuranceProductSelectPageRequest;
import com.yd.insurance.base.feign.response.ApiRelTenantInsuranceProductListPageResponse;
import com.yd.insurance.base.feign.response.ApiRelTenantInsuranceProductSelectPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 租户-保险产品关系信息
 *
 * @author zxm
 * @since 2025-08-25
 */
@RestController
@RequestMapping("/relTenantInsuranceProduct")
@Validated
public class ApiRelTenantInsuranceProductController implements ApiRelTenantInsuranceProductFeignClient {

    @Autowired
    private ApiRelTenantInsuranceProductService apiRelTenantInsuranceProductService;

    /**
     * 租户和保险产品关系分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelTenantInsuranceProductListPageResponse>> page(ApiRelTenantInsuranceProductListPageRequest request) {
        return apiRelTenantInsuranceProductService.page(request);
    }

    /**
     * 添加租户和保险产品列表关系
     * @param request
     * @return
     */
    @Override
    public Result addProductList(ApiRelTenantInsuranceProductListAddRequest request) {
        return apiRelTenantInsuranceProductService.addProductList(request);
    }

    /**
     * 删除租户和保险产品关系
     * @param id 租户和保险产品关系表主键id
     * @return
     */
    @Override
    public Result del(Long id) {
        return apiRelTenantInsuranceProductService.del(id);
    }

    /**
     * 导入-选择保险产品分页查询（查询当前租户级（当前所属租户绑定的保险产品）或者系统级（全局保险产品在任何地方都适用导入绑定）的保险产品表数据）
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelTenantInsuranceProductSelectPageResponse>> selectProductPage(ApiRelTenantInsuranceProductSelectPageRequest request) {
        return apiRelTenantInsuranceProductService.selectProductPage(request);
    }
}
