package com.yd.insurance.base.feign.client;

import com.yd.common.result.Result;
import com.yd.insurance.base.feign.fallback.ApiInsuranceProductPlanFeignFallbackFactory;
import com.yd.insurance.base.feign.request.ApiInsuranceProductPlanAddRequest;
import com.yd.insurance.base.feign.request.ApiInsuranceProductPlanEditRequest;
import com.yd.insurance.base.feign.request.ApiInsuranceProductPlanPageRequest;
import com.yd.insurance.base.feign.response.ApiInsuranceProductPlanDetailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 保险基础数据服务-保险产品计划信息Feign客户端
 */
@FeignClient(name = "yd-insurance-base-api", fallbackFactory = ApiInsuranceProductPlanFeignFallbackFactory.class)
public interface ApiInsuranceProductPlanFeignClient {

    /**
     * 保险产品计划分页查询
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiInsuranceProductPlanPageRequest request);

    /**
     * 获取保险产品计划详情
     * @param planBizId 保险产品计划唯一标识(业务ID)
     * @return
     */
    @GetMapping("/detail")
    Result<ApiInsuranceProductPlanDetailResponse> detail(@NotBlank(message = "保险产品计划唯一标识(业务ID)不能为空") @RequestParam(value = "planBizId") String planBizId);

    /**
     * 添加保险产品计划
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiInsuranceProductPlanAddRequest request);

    /**
     * 编辑保险产品计划
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiInsuranceProductPlanEditRequest request);


    /**
     * 删除保险产品计划（逻辑删除）
     * @param planBizId 保险产品计划唯一标识(业务ID)
     * @return
     */
    @DeleteMapping("/del")
    Result del(@RequestParam(value = "planBizId") String planBizId);

    /**
     * 编辑保险产品计划状态
     * @param planBizId 保险产品计划唯一标识(业务ID)
     * @param status 状态(0:禁用 1:启用)
     * @return
     */
    @PatchMapping("/edit/status")
    Result editStatus(@NotBlank(message = "保险产品计划唯一标识(业务ID)不能为空") @RequestParam(value = "planBizId") String planBizId,
                      @NotNull(message = "状态不能为空") @RequestParam(value = "status") Integer status);
}
