package com.yd.insurance.base.feign.client;

import com.yd.common.result.Result;
import com.yd.insurance.base.feign.fallback.ApiRelProductAnnouncementFeignFallbackFactory;
import com.yd.insurance.base.feign.request.ApiQueryRatioRequest;
import com.yd.insurance.base.feign.response.ApiQueryRatioResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 保险基础数据服务-产品和公告比例关系信息Feign客户端
 */
@FeignClient(name = "yd-insurance-base-api", fallbackFactory = ApiRelProductAnnouncementFeignFallbackFactory.class)
public interface ApiRelProductAnnouncementFeignClient {

    /**
     * 查询-产品公告比例
     * @param request
     * @return
     */
    @PostMapping("/query/ratio")
    Result<ApiQueryRatioResponse> queryRatio(@RequestBody ApiQueryRatioRequest request);
}
