package com.yd.insurance.base.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 组织架构-保险公司扩展表
 * </p>
 *
 * @author zxm
 * @since 2025-08-25
 */
@Getter
@Setter
@TableName("insurance_company_expand")
public class InsuranceCompanyExpand implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 保险公司唯一业务ID
     */
    @TableField("company_biz_id")
    private String companyBizId;

    /**
     * 组织唯一标识(业务ID)
     */
    @TableField("dept_biz_id")
    private String deptBizId;

    /**
     * 保险公司名称
     */
    @TableField("company_name")
    private String companyName;

    /**
     * 保险公司编码
     */
    @TableField("company_code")
    private String companyCode;

    /**
     * 所属地区
     */
    @TableField("region")
    private String region;

    /**
     * 官方联系电话
     */
    @TableField("contact_phone")
    private String contactPhone;

    /**
     * 官方邮箱
     */
    @TableField("contact_email")
    private String contactEmail;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
