package com.yd.insurance.base.api.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.insurance.base.feign.request.ApiInsuranceProductAddRequest;
import com.yd.insurance.base.feign.request.ApiInsuranceProductEditRequest;
import com.yd.insurance.base.feign.request.ApiInsuranceProductPageRequest;
import com.yd.insurance.base.feign.response.ApiInsuranceProductDetailResponse;
import com.yd.insurance.base.feign.response.ApiInsuranceProductPageResponse;

public interface ApiInsuranceProductService {
    Result<IPage<ApiInsuranceProductPageResponse>> page(ApiInsuranceProductPageRequest request);

    Result<ApiInsuranceProductDetailResponse> detail(String productBizId);

    Result add(ApiInsuranceProductAddRequest request);

    Result edit(ApiInsuranceProductEditRequest request);

    Result del(String productBizId);

    Result editStatus(String productBizId, Integer status);
}
