package com.yd.insurance.base.api.service.impl;

import com.yd.common.result.Result;
import com.yd.insurance.base.api.service.ApiRelProductAnnouncementService;
import com.yd.insurance.base.feign.dto.ApiProductRatioDto;
import com.yd.insurance.base.feign.request.ApiQueryRatioRequest;
import com.yd.insurance.base.feign.response.ApiQueryRatioResponse;
import com.yd.insurance.base.service.dto.RelProductAnnouncementDto;
import com.yd.insurance.base.service.model.RelProductAnnouncement;
import com.yd.insurance.base.service.service.IRelProductAnnouncementService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Slf4j
@Service
public class ApiRelProductAnnouncementServiceImpl implements ApiRelProductAnnouncementService {

    @Autowired
    private IRelProductAnnouncementService iRelProductAnnouncementService;

    /**
     * 查询-产品公告比例
     * @param request
     * @return
     */
    @Override
    public Result<ApiQueryRatioResponse> queryRatio(ApiQueryRatioRequest request) {
        LocalDateTime now = LocalDateTime.now();
        ApiQueryRatioResponse ratioResponse = new ApiQueryRatioResponse();
        List<ApiProductRatioDto> apiProductRatioDtoList = request.getApiProductRatioDtoList();
        if (!CollectionUtils.isEmpty(apiProductRatioDtoList)) {
            //产品代码列表
            List<String> productCodeList = apiProductRatioDtoList.stream()
                    .map(ApiProductRatioDto::getProductCode)
                    .collect(Collectors.toList());
            //产品业务ID列表
            List<String> productBizIdList = apiProductRatioDtoList.stream()
                    .map(ApiProductRatioDto::getProductBizId)
                    .collect(Collectors.toList());
            List<RelProductAnnouncement> productAnnouncementDtoList = new ArrayList<>();
            //查询产品和公告比例关系列表信息
            if (!CollectionUtils.isEmpty(productCodeList)) {
                productAnnouncementDtoList = iRelProductAnnouncementService.queryList(RelProductAnnouncementDto.builder()
                        .productCodeList(productCodeList)
                        .build());
            }else {
                productAnnouncementDtoList = iRelProductAnnouncementService.queryList(RelProductAnnouncementDto.builder()
                        .productBizIdList(productBizIdList)
                        .build());
            }
            if (!CollectionUtils.isEmpty(productAnnouncementDtoList)) {
                List<RelProductAnnouncement> finalProductAnnouncementDtoList = productAnnouncementDtoList;
                apiProductRatioDtoList.stream().map(dto -> {
                    //根据产品代码或者产品业务ID获取产品和公告比例关系列表信息
                    List<RelProductAnnouncement> announcementList =  finalProductAnnouncementDtoList.stream()
                            .filter(d -> d.getProductCode().equals(dto.getProductCode())
                            || d.getProductBizId().equals(dto.getProductBizId())).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(announcementList)) {
                        //先判断当前计算的产品时间是否在有效期内，如果在有效期内，用有效期内的公告比例
                        List<RelProductAnnouncement> announcements = announcementList.stream()
                                .filter(d -> d.getStartPayment() <= dto.getCommissionPeriod()
                                        && d.getEndPayment() > dto.getCommissionPeriod()).collect(Collectors.toList());
                        if (!CollectionUtils.isEmpty(announcements)) {
                            //当前计算获取的产品公告比例对象
                            RelProductAnnouncement announcement = announcements.get(0);
                            //先判断当前时间是否在有效期内，在有效期内，公告比例取值有效期内公告比例字段值, 否则取公告比例字段
                            if ((!Objects.isNull(announcement.getEffectiveStart()) && now.compareTo(announcement.getEffectiveStart()) >= 0)
                                && (!Objects.isNull(announcement.getEffectiveEnd()) && now.compareTo(announcement.getEffectiveEnd()) <= 0)) {
                                dto.setRatio(announcement.getRatio());
                            }else {
                                dto.setRatio(announcement.getAnnouncementRatio());
                            }
                        }
                    }
                    return dto;
                }).collect(Collectors.toList());
            }
        }
        ratioResponse.setApiProductRatioDtoList(apiProductRatioDtoList);
        return Result.success(ratioResponse);
    }

}
