package com.yd.insurance.base.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.common.enums.ResultCode;
import com.yd.common.exception.BusinessException;
import com.yd.common.result.Result;
import com.yd.insurance.base.api.service.ApiRelTenantInsuranceProductService;
import com.yd.insurance.base.feign.request.ApiRelTenantInsuranceProductListAddRequest;
import com.yd.insurance.base.feign.request.ApiRelTenantInsuranceProductListPageRequest;
import com.yd.insurance.base.feign.request.ApiRelTenantInsuranceProductSelectPageRequest;
import com.yd.insurance.base.feign.response.ApiRelTenantInsuranceProductListPageResponse;
import com.yd.insurance.base.feign.response.ApiRelTenantInsuranceProductSelectPageResponse;
import com.yd.insurance.base.service.model.RelTenantInsuranceProduct;
import com.yd.insurance.base.service.service.IRelTenantInsuranceProductService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Service
public class ApiRelTenantInsuranceProductServiceImpl implements ApiRelTenantInsuranceProductService {

    @Autowired
    private IRelTenantInsuranceProductService iRelTenantInsuranceProductService;

    /**
     * 租户和保险产品关系分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelTenantInsuranceProductListPageResponse>> page(ApiRelTenantInsuranceProductListPageRequest request) {
        Page<ApiRelTenantInsuranceProductListPageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiRelTenantInsuranceProductListPageResponse> iPage = iRelTenantInsuranceProductService.page(page, request);
        return Result.success(iPage);
    }

    /**
     * 添加租户和保险产品列表关系
     * @param request
     * @return
     */
    @Override
    public Result addProductList(ApiRelTenantInsuranceProductListAddRequest request) {
        List<RelTenantInsuranceProduct> list = new ArrayList<>();
        if (!CollectionUtils.isEmpty(request.getProductBizIdList())) {
            //产品唯一标识(业务ID) 列表（选中列表）不为空
            list = request.getProductBizIdList().stream().map(bizId -> {
                RelTenantInsuranceProduct relTenantInsuranceProduct = new RelTenantInsuranceProduct();
                relTenantInsuranceProduct.setTenantBizId(request.getTenantBizId());
                relTenantInsuranceProduct.setProductBizId(bizId);
                return relTenantInsuranceProduct;
            }).collect(Collectors.toList());

            iRelTenantInsuranceProductService.saveOrUpdateBatch(list);
        }

        return Result.success();
    }

    /**
     * 删除租户和保险产品关系
     * @param id 租户和保险产品关系表主键id
     * @return
     */
    @Override
    public Result del(Long id) {
        RelTenantInsuranceProduct relTenantInsuranceProduct = iRelTenantInsuranceProductService.queryOne(id);
        if (Objects.isNull(relTenantInsuranceProduct)) {
            //数据不存在
            throw new BusinessException(ResultCode.NULL_ERROR.getCode(),ResultCode.NULL_ERROR.getMessage());
        }
        iRelTenantInsuranceProductService.removeById(relTenantInsuranceProduct.getId());
        return Result.success();
    }

    /**
     * 导入-保险产品分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelTenantInsuranceProductSelectPageResponse>> selectProductPage(ApiRelTenantInsuranceProductSelectPageRequest request) {
        Page<ApiRelTenantInsuranceProductSelectPageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiRelTenantInsuranceProductSelectPageResponse> iPage = iRelTenantInsuranceProductService.selectProductPage(page, request);
        return Result.success(iPage);
    }

    /**
     * 添加-单个租户和保险产品关系
     * @param tenantBizId
     * @param roleBizId
     * @return
     */
    @Override
    public Result addSingleRel(String tenantBizId, String roleBizId) {
        //新增关系
        RelTenantInsuranceProduct relTenantInsuranceProduct = new RelTenantInsuranceProduct();
        relTenantInsuranceProduct.setTenantBizId(tenantBizId);
        relTenantInsuranceProduct.setProductBizId(roleBizId);
        iRelTenantInsuranceProductService.saveOrUpdate(relTenantInsuranceProduct);
        return Result.success();
    }
}
