package com.yd.insurance.base.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.common.enums.CommonEnum;
import com.yd.common.enums.ResultCode;
import com.yd.common.exception.BusinessException;
import com.yd.common.result.Result;
import com.yd.common.utils.RandomStringGenerator;
import com.yd.insurance.base.api.service.ApiUserSaleExpandService;
import com.yd.insurance.base.feign.request.usersaleexpand.ApiUserSaleExpandAddRequest;
import com.yd.insurance.base.feign.request.usersaleexpand.ApiUserSaleExpandEditRequest;
import com.yd.insurance.base.feign.request.usersaleexpand.ApiUserSaleExpandPageRequest;
import com.yd.insurance.base.feign.response.usersaleexpand.ApiUserSaleExpandDetailResponse;
import com.yd.insurance.base.feign.response.usersaleexpand.ApiUserSaleExpandPageResponse;
import com.yd.insurance.base.service.model.UserSaleExpand;
import com.yd.insurance.base.service.service.IUserSaleExpandService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

@Slf4j
@Service
public class ApiUserSaleExpandServiceImpl implements ApiUserSaleExpandService {

    @Autowired
    private IUserSaleExpandService iUserSaleExpandService;

    /**
     * 销售员（转介人）分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiUserSaleExpandPageResponse>> page(ApiUserSaleExpandPageRequest request) {
        Page<ApiUserSaleExpandPageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiUserSaleExpandPageResponse> iPage = iUserSaleExpandService.page(page, request);
        return Result.success(iPage);
    }

    /**
     * 获取销售员（转介人）详情
     * @param userSaleBizId 销售员（转介人）唯一标识(业务ID)
     * @return
     */
    @Override
    public Result<ApiUserSaleExpandDetailResponse> detail(String userSaleBizId) {
        Result<UserSaleExpand> result = checkUserSaleExpandIsExist(userSaleBizId);
        UserSaleExpand userSaleExpand = result.getData();
        ApiUserSaleExpandDetailResponse response = new ApiUserSaleExpandDetailResponse();
        BeanUtils.copyProperties(userSaleExpand,response);
        return Result.success(response);
    }

    /**
     * 添加销售员（转介人）
     * @param request
     * @return
     */
    @Override
    public Result add(ApiUserSaleExpandAddRequest request) {
        UserSaleExpand userSaleExpand = new UserSaleExpand();
        BeanUtils.copyProperties(request,userSaleExpand);
        userSaleExpand.setUserSaleBizId(RandomStringGenerator.generateBizId16(CommonEnum.UID_TYPE_USER_SALE_EXPAND.getCode()));
        iUserSaleExpandService.saveOrUpdate(userSaleExpand);
        return Result.success();
    }

    /**
     * 编辑销售员（转介人）
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiUserSaleExpandEditRequest request) {
        Result<UserSaleExpand> result = checkUserSaleExpandIsExist(request.getUserSaleBizId());
        UserSaleExpand userSaleExpand = result.getData();
        BeanUtils.copyProperties(request,userSaleExpand);
        iUserSaleExpandService.saveOrUpdate(userSaleExpand);
        return Result.success();
    }

    /**
     * 删除销售员（转介人）（逻辑删除）
     * @param userSaleBizId 销售员（转介人）唯一标识(业务ID)
     * @return
     */
    @Override
    public Result del(String userSaleBizId) {
        return null;
    }

    /**
     * 编辑销售员（转介人）状态
     * @param userSaleBizId 销售员（转介人）唯一标识(业务ID)
     * @param status 状态(0:禁用 1:启用)
     * @return
     */
    @Override
    public Result editStatus(String userSaleBizId, Integer status) {
        Result<UserSaleExpand> result = checkUserSaleExpandIsExist(userSaleBizId);
        UserSaleExpand userSaleExpand = result.getData();
        userSaleExpand.setStatus(status);
        iUserSaleExpandService.saveOrUpdate(userSaleExpand);
        return Result.success();
    }

    /**
     * 校验销售员（转介人）是否存在
     * @param userSaleBizId
     * @return
     */
    public Result<UserSaleExpand> checkUserSaleExpandIsExist(String userSaleBizId) {
        UserSaleExpand userSaleExpand = iUserSaleExpandService.queryOne(userSaleBizId);
        if (Objects.isNull(userSaleExpand)) {
            //数据不存在
            throw new BusinessException(ResultCode.NULL_ERROR.getCode(),ResultCode.NULL_ERROR.getMessage());
        }
        return Result.success(userSaleExpand);
    }
}
