package com.yd.insurance.base.feign.fallback.usersignexpand;

import com.yd.common.result.Result;
import com.yd.insurance.base.feign.client.usersignexpand.ApiUserSignExpandFeignClient;
import com.yd.insurance.base.feign.request.usersignexpand.ApiUserSignExpandAddRequest;
import com.yd.insurance.base.feign.request.usersignexpand.ApiUserSignExpandEditRequest;
import com.yd.insurance.base.feign.request.usersignexpand.ApiUserSignExpandPageRequest;
import com.yd.insurance.base.feign.response.usersignexpand.ApiUserSignExpandDetailResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 系统用户-签单用户扩展信息Feign降级处理
 */
@Slf4j
@Component
public class ApiUserSignExpandFeignFallbackFactory implements FallbackFactory<ApiUserSignExpandFeignClient> {
    @Override
    public ApiUserSignExpandFeignClient create(Throwable cause) {
        return new ApiUserSignExpandFeignClient() {
            @Override
            public Result page(ApiUserSignExpandPageRequest request) {
                return null;
            }

            @Override
            public Result<ApiUserSignExpandDetailResponse> detail(String userSignBizId) {
                return null;
            }

            @Override
            public Result add(ApiUserSignExpandAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiUserSignExpandEditRequest request) {
                return null;
            }

            @Override
            public Result del(String userSignBizId) {
                return null;
            }

            @Override
            public Result editStatus(String userSignBizId, Integer status) {
                return null;
            }
        };
    }
}
