package com.yd.insurance.base.feign.response;

import com.yd.insurance.base.feign.dto.CdDeptDto;
import com.yd.insurance.base.feign.dto.PlanDto;
import com.yd.insurance.base.feign.dto.SsDeptDto;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class ApiInsuranceAdditionalProductDetailResponse {

    /**
     * 保险附加产品主键id
     */
    private Long id;

    /**
     * 保险附加产品唯一业务ID
     */
    private String additionalProductBizId;

    /**
     * 保险附加产品名称
     */
    private String productName;

    /**
     * 保险附加产品类型
     */
    private String productType;

    /**
     * 支持货币
     */
    private String currency;

    /**
     * 供款年期
     */
    private String paymentTerm;

    /**
     * 受保年龄范围
     */
    private String insuredAgeRange;

    /**
     * 是否区分吸烟：0=不区分，1=区分
     */
    private Integer smokingAllowed;

    /**
     * 保障内容
     */
    private String coverageContent;

    /**
     * 基础费率
     */
    private BigDecimal premiumRate;

    /**
     * 保险附加产品状态：0=下架，1=在售
     */
    private Integer productStatus;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 绑定供款年期列表
     */
    private List<String> paymentTermList;

    /**
     * 绑定产品所属保险公司对象集合
     */
    private List<SsDeptDto> ssDeptDtoList;

    /**
     * 绑定保险附加产品出单公司对象集合
     */
    private List<CdDeptDto> cdDeptDtoList;

    /**
     * 附加产品图片
     */
    private String picture;

    /**
     * 附加产品所属公司的所在地
     */
    private String location;
}
