package com.yd.insurance.base.service.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.insurance.base.feign.request.ApiInsuranceProductPageRequest;
import com.yd.insurance.base.feign.response.ApiInsuranceProductPageResponse;
import com.yd.insurance.base.service.model.InsuranceProduct;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 保险产品基础表 Mapper 接口
 * </p>
 *
 * @author zxm
 * @since 2025-08-25
 */
public interface InsuranceProductMapper extends BaseMapper<InsuranceProduct> {

    IPage<ApiInsuranceProductPageResponse> page(@Param("page") Page<ApiInsuranceProductPageResponse> page,
                                                @Param("request") ApiInsuranceProductPageRequest request,
                                                @Param("isAdmin") Boolean isAdmin,
                                                @Param("projectBizIdList") List<String> projectBizIdList,
                                                @Param("loginTenantBizId") String loginTenantBizId);
}
