package com.yd.insurance.base.service.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class InsuranceAdditionalProductDto {

    /**
     * 主键id
     */
    private Long id;

    /**
     * 保险附加产品唯一标识(业务ID)
     */
    private String additionalProductBizId;

    /**
     * 保险附加产品唯一标识(业务ID)集合
     */
    private List<String> additionalProductBizIdList;

    /**
     * 保险附加产品名称
     */
    private String productName;

    /**
     * 查询是否排除当前保险附加产品唯一标识数据，默认false不排除，true的话additionalProductBizId必传
     */
    @Builder.Default
    private Boolean isExcludeMy = false;
}
