package com.yd.insurance.base.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 保险产品-部门关系表（多对多关系）
 * </p>
 *
 * @author zxm
 * @since 2025-08-27
 */
@Getter
@Setter
@TableName("rel_insurance_product_dept")
public class RelInsuranceProductDept implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 保险产品ID（业务id）
     */
    @TableField("product_biz_id")
    private String productBizId;

    /**
     * 部门唯一标识(业务ID)
     */
    @TableField("dept_biz_id")
    private String deptBizId;

    /**
     * 类型(1-所属保险公司 2-出单公司)
     */
    @TableField("type")
    private Integer type;

    /**
     * 状态(0:禁用 1:启用)
     */
    @TableField("status")
    private Integer status;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
