package com.yd.insurance.base.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 产品和公告比例关系表
 * </p>
 *
 * @author zxm
 * @since 2025-10-28
 */
@Getter
@Setter
@TableName("rel_product_announcement")
public class RelProductAnnouncement implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 保险产品唯一业务ID
     */
    @TableField("product_biz_id")
    private String productBizId;

    /**
     * 保险产品代码
     */
    @TableField("product_code")
    private String productCode;

    /**
     * 缴费期范围开始期数（例：1-第一年）
     */
    @TableField("start_payment")
    private Integer startPayment;

    /**
     * 缴费期范围结束期数（例：2-  第一年到第二年，不包含结束期数，例： 当前缴费来佣期是第一期，那么就是1-2第一年到第二年）
     */
    @TableField("end_payment")
    private Integer endPayment;

    /**
     * 公告比例
     */
    @TableField("announcement_ratio")
    private BigDecimal announcementRatio;

    /**
     * 有效开始时间
     */
    @TableField("effective_start")
    private LocalDateTime effectiveStart;

    /**
     * 有效结束时间（不在这个时间区间内，公告比例按照announcement_ratio算，在这个区间内公告比例按照有效期内公告比例算）
     */
    @TableField("effective_end")
    private LocalDateTime effectiveEnd;

    /**
     * 有效期内公告比例
     */
    @TableField("ratio")
    private BigDecimal ratio;

    /**
     * 状态(0:停用 1:启用)
     */
    @TableField("status")
    private Integer status;

    /**
     * 所属租户唯一业务ID（冗余）
     */
    @TableField("tenant_biz_id")
    private String tenantBizId;

    /**
     * 所属项目唯一业务ID（冗余）
     */
    @TableField("project_biz_id")
    private String projectBizId;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
