package com.yd.insurance.base.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.insurance.base.feign.request.ApiInsuranceAdditionalProductPageRequest;
import com.yd.insurance.base.feign.response.ApiInsuranceAdditionalProductPageResponse;
import com.yd.insurance.base.service.dto.InsuranceAdditionalProductDto;
import com.yd.insurance.base.service.model.InsuranceAdditionalProduct;
import com.yd.insurance.base.service.dao.InsuranceAdditionalProductMapper;
import com.yd.insurance.base.service.model.InsuranceProduct;
import com.yd.insurance.base.service.service.IInsuranceAdditionalProductService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 保险附加产品基础表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-08-29
 */
@Service
public class InsuranceAdditionalProductServiceImpl extends ServiceImpl<InsuranceAdditionalProductMapper, InsuranceAdditionalProduct> implements IInsuranceAdditionalProductService {

    @Override
    public IPage<ApiInsuranceAdditionalProductPageResponse> page(Page<ApiInsuranceAdditionalProductPageResponse> page,
                                                                 ApiInsuranceAdditionalProductPageRequest request) {
        return baseMapper.page(page,request);
    }

    /**
     * 查询单个对象
     * @param additionalProductBizId
     * @return
     */
    @Override
    public InsuranceAdditionalProduct queryOne(String additionalProductBizId) {
        return this.getOne(new LambdaQueryWrapper<InsuranceAdditionalProduct>().eq(InsuranceAdditionalProduct::getAdditionalProductBizId,additionalProductBizId));
    }

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<InsuranceAdditionalProduct> queryList(InsuranceAdditionalProductDto dto) {
        List<InsuranceAdditionalProduct> list = baseMapper.selectList(new LambdaQueryWrapper<InsuranceAdditionalProduct>()
                .eq(!Objects.isNull(dto.getId()),InsuranceAdditionalProduct::getId,dto.getId())
                .eq(StringUtils.isNotBlank(dto.getAdditionalProductBizId()) && !dto.getIsExcludeMy(),InsuranceAdditionalProduct::getAdditionalProductBizId,dto.getAdditionalProductBizId())
                .eq(StringUtils.isNotBlank(dto.getProductName()),InsuranceAdditionalProduct::getProductName,dto.getProductName())
                .in(!CollectionUtils.isEmpty(dto.getAdditionalProductBizIdList()),InsuranceAdditionalProduct::getAdditionalProductBizId,dto.getAdditionalProductBizIdList())
                .ne(dto.getIsExcludeMy(),InsuranceAdditionalProduct::getAdditionalProductBizId,dto.getAdditionalProductBizId())
        );
        return list;
    }
}
