package com.yd.insurance.base.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.insurance.base.service.dto.RelInsuranceAdditionalProductDeptDto;
import com.yd.insurance.base.service.model.RelInsuranceAdditionalProductDept;
import com.yd.insurance.base.service.dao.RelInsuranceAdditionalProductDeptMapper;
import com.yd.insurance.base.service.model.RelInsuranceProductDept;
import com.yd.insurance.base.service.service.IRelInsuranceAdditionalProductDeptService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 保险附加产品-部门关系表（多对多关系） 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-08-31
 */
@Service
public class RelInsuranceAdditionalProductDeptServiceImpl extends ServiceImpl<RelInsuranceAdditionalProductDeptMapper, RelInsuranceAdditionalProductDept> implements IRelInsuranceAdditionalProductDeptService {

    /**
     * 根据类型和附加产品id删除附加产品部门关系
     * @param type
     * @param additionalProductBizId
     * @return
     */
    @Override
    public Boolean removeByAdditionalProductBizIdAndType(Integer type, String additionalProductBizId) {
        return this.remove(new LambdaQueryWrapper<RelInsuranceAdditionalProductDept>()
                .eq(RelInsuranceAdditionalProductDept::getType,type)
                .eq(RelInsuranceAdditionalProductDept::getAdditionalProductBizId,additionalProductBizId)
        );
    }

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<RelInsuranceAdditionalProductDept> queryList(RelInsuranceAdditionalProductDeptDto dto) {
        List<RelInsuranceAdditionalProductDept> list = baseMapper.selectList(new LambdaQueryWrapper<RelInsuranceAdditionalProductDept>()
                .eq(StringUtils.isNotBlank(dto.getAdditionalProductBizId()),RelInsuranceAdditionalProductDept::getAdditionalProductBizId,dto.getAdditionalProductBizId())
                .eq(!Objects.isNull(dto.getType()),RelInsuranceAdditionalProductDept::getType,dto.getType())
        );
        return list;
    }
}
