package com.yd.insurance.base.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.insurance.base.service.dto.RelInsuranceAdditionalProductDto;
import com.yd.insurance.base.service.model.InsuranceProduct;
import com.yd.insurance.base.service.model.RelInsuranceAdditionalProduct;
import com.yd.insurance.base.service.dao.RelInsuranceAdditionalProductMapper;
import com.yd.insurance.base.service.service.IRelInsuranceAdditionalProductService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 保险产品-保险附加产品关系表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-08-29
 */
@Service
public class RelInsuranceAdditionalProductServiceImpl extends ServiceImpl<RelInsuranceAdditionalProductMapper, RelInsuranceAdditionalProduct> implements IRelInsuranceAdditionalProductService {

    /**
     * 根据产品业务id删除关系
     * @param productBizId
     * @return
     */
    @Override
    public Boolean removeByProductBizId(String productBizId) {
        return this.remove(new LambdaQueryWrapper<RelInsuranceAdditionalProduct>().eq(RelInsuranceAdditionalProduct::getProductBizId,productBizId));
    }

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<RelInsuranceAdditionalProduct> queryList(RelInsuranceAdditionalProductDto dto) {
        List<RelInsuranceAdditionalProduct> list = baseMapper.selectList(new LambdaQueryWrapper<RelInsuranceAdditionalProduct>()
                .eq(StringUtils.isNotBlank(dto.getProductBizId()),RelInsuranceAdditionalProduct::getProductBizId,dto.getProductBizId())
        );
        return list;
    }

}
