package com.yd.insurance.base.service.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.insurance.base.feign.request.ApiRelTenantInsuranceProductListPageRequest;
import com.yd.insurance.base.feign.request.ApiRelTenantInsuranceProductSelectPageRequest;
import com.yd.insurance.base.feign.response.ApiRelTenantInsuranceProductListPageResponse;
import com.yd.insurance.base.feign.response.ApiRelTenantInsuranceProductSelectPageResponse;
import com.yd.insurance.base.service.model.RelTenantInsuranceProduct;
import com.yd.insurance.base.service.dao.RelTenantInsuranceProductMapper;
import com.yd.insurance.base.service.service.IRelTenantInsuranceProductService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 租户-保险产品关系表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-08-25
 */

@Slf4j
@Primary
@Service
public class RelTenantInsuranceProductServiceImpl extends ServiceImpl<RelTenantInsuranceProductMapper, RelTenantInsuranceProduct> implements IRelTenantInsuranceProductService {

    @Override
    public IPage<ApiRelTenantInsuranceProductListPageResponse> page(Page<ApiRelTenantInsuranceProductListPageResponse> page,
                                                                    ApiRelTenantInsuranceProductListPageRequest request) {
        return baseMapper.page(page,request);
    }

    /**
     * 根据主键id查询单个对象
     * @param id
     * @return
     */
    @Override
    public RelTenantInsuranceProduct queryOne(Long id) {
        return this.getById(id);
    }

    @Override
    public IPage<ApiRelTenantInsuranceProductSelectPageResponse> selectProductPage(Page<ApiRelTenantInsuranceProductSelectPageResponse> page,
                                                                                   ApiRelTenantInsuranceProductSelectPageRequest request) {
        return baseMapper.selectProductPage(page,request);
    }
}
