package com.yd.insurance.base.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 保险产品基础表
 * </p>
 *
 * @author zxm
 * @since 2025-08-25
 */
@Getter
@Setter
@TableName("insurance_product")
public class InsuranceProduct implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 保险产品唯一业务ID
     */
    @TableField("product_biz_id")
    private String productBizId;

    /**
     * 保险产品名称
     */
    @TableField("product_name")
    private String productName;

    /**
     * 保险产品类型
     */
    @TableField("product_type")
    private String productType;

    /**
     * 支持货币
     */
    @TableField("currency")
    private String currency;

    /**
     * 供款年期
     */
    @TableField("payment_term")
    private String paymentTerm;

    /**
     * 受保年龄范围
     */
    @TableField("insured_age_range")
    private String insuredAgeRange;

    /**
     * 是否区分吸烟：0=不区分，1=区分
     */
    @TableField("smoking_allowed")
    private Byte smokingAllowed;

    /**
     * 保障内容
     */
    @TableField("coverage_content")
    private String coverageContent;

    /**
     * 基础费率
     */
    @TableField("premium_rate")
    private BigDecimal premiumRate;

    /**
     * 保险产品状态：0=下架，1=在售
     */
    @TableField("product_status")
    private Byte productStatus;

    /**
     * 作用域(1:系统级（全局） 2:租户级 3:项目级)
     */
    @TableField("scope")
    private Byte scope;

    /**
     * 所属租户ID（业务id）
     */
    @TableField("tenant_biz_id")
    private String tenantBizId;

    /**
     * 所属项目ID（业务id）
     */
    @TableField("project_biz_id")
    private String projectBizId;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Boolean isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
