package com.yd.insurance.base.api.service.impl;

import com.yd.common.result.Result;
import com.yd.insurance.base.api.service.ApiRelInsuranceProductPlanService;
import com.yd.insurance.base.feign.dto.CdDeptDto;
import com.yd.insurance.base.feign.dto.PlanDto;
import com.yd.insurance.base.service.dto.InsuranceProductPlanDto;
import com.yd.insurance.base.service.model.InsuranceProductPlan;
import com.yd.insurance.base.service.model.RelInsuranceProductPlan;
import com.yd.insurance.base.service.service.IInsuranceProductPlanService;
import com.yd.insurance.base.service.service.IRelInsuranceProductPlanService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class ApiRelInsuranceProductPlanServiceImpl implements ApiRelInsuranceProductPlanService {

    @Autowired
    private IRelInsuranceProductPlanService iRelInsuranceProductPlanService;

    @Autowired
    private IInsuranceProductPlanService iInsuranceProductPlanService;

    /**
     * 更新保险产品和保险产品计划列表的关系数据（先删后增加）
     * @param productBizId
     * @param planBizIdList
     * @return
     */
    @Override
    public Result updateRelInsuranceProductPlanList(String productBizId, List<String> planBizIdList) {
        //先删后增加
        iRelInsuranceProductPlanService.removeByProductBizId(productBizId);

        List<RelInsuranceProductPlan> list = new ArrayList<>();
        if (!CollectionUtils.isEmpty(planBizIdList)) {
            //产品计划唯一标识(业务ID) 列表（选中列表）不为空
            list = planBizIdList.stream().map(bizId -> {
                RelInsuranceProductPlan relInsuranceProductPlan = new RelInsuranceProductPlan();
                relInsuranceProductPlan.setProductBizId(productBizId);
                relInsuranceProductPlan.setPlanBizId(bizId);
                return relInsuranceProductPlan;
            }).collect(Collectors.toList());

            iRelInsuranceProductPlanService.saveOrUpdateBatch(list);
        }
        return Result.success();
    }

    /**
     * 根据产品id获取计划集合
     * @param productBizId
     * @return
     */
    @Override
    public Result<List<PlanDto>> getPlanDtoList(String productBizId) {
        List<PlanDto> planDtoList = new ArrayList<>();
        List<RelInsuranceProductPlan> list = iRelInsuranceProductPlanService.queryList(productBizId);

        if (!CollectionUtils.isEmpty(list)) {
            List<String> planBizIdList = list.stream().map(RelInsuranceProductPlan::getPlanBizId).collect(Collectors.toList());
            List<InsuranceProductPlan> insuranceProductPlanList = iInsuranceProductPlanService.queryList(InsuranceProductPlanDto.builder()
                    .planBizIdList(planBizIdList)
                    .build());
            if (!CollectionUtils.isEmpty(insuranceProductPlanList)) {
                planDtoList = insuranceProductPlanList.stream().map(dto -> {
                    PlanDto planDto = new PlanDto();
                    BeanUtils.copyProperties(dto,planDto);
                    return planDto;
                }).collect(Collectors.toList());
            }
        }
        return Result.success(planDtoList);
    }
}
