package com.yd.insurance.base.service.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.insurance.base.feign.request.ApiInsuranceProductPlanPageRequest;
import com.yd.insurance.base.feign.response.ApiInsuranceProductPlanPageResponse;
import com.yd.insurance.base.service.dto.InsuranceProductPlanDto;
import com.yd.insurance.base.service.model.InsuranceProductPlan;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
 * <p>
 * 保险产品计划表 服务类
 * </p>
 *
 * @author zxm
 * @since 2025-08-25
 */
public interface IInsuranceProductPlanService extends IService<InsuranceProductPlan> {

    List<InsuranceProductPlan> queryList(InsuranceProductPlanDto dto);

    InsuranceProductPlan queryOne(String planBizId);

    IPage<ApiInsuranceProductPlanPageResponse> page(Page<ApiInsuranceProductPlanPageResponse> page,
                                                    ApiInsuranceProductPlanPageRequest request);
    Boolean removeByPlanBizId(String planBizId);
}
