package com.yd.insurance.base.feign.client.insurancecompany;

import com.yd.common.result.Result;
import com.yd.insurance.base.feign.fallback.insurancecompany.ApiInsuranceCompanyFeignFallbackFactory;
import com.yd.insurance.base.feign.request.insurancecompany.ApiInsuranceCompanyAddRequest;
import com.yd.insurance.base.feign.request.insurancecompany.ApiInsuranceCompanyEditRequest;
import com.yd.insurance.base.feign.request.insurancecompany.ApiInsuranceCompanyPageRequest;
import com.yd.insurance.base.feign.response.insurancecompany.ApiInsuranceCompanyDetailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import javax.validation.constraints.NotBlank;

/**
 * 保险公司信息Feign客户端
 */
@FeignClient(name = "yd-user-api", fallbackFactory = ApiInsuranceCompanyFeignFallbackFactory.class)
public interface ApiInsuranceCompanyFeignClient {

    /**
     * 分页列表查询-保险公司信息
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiInsuranceCompanyPageRequest request);

    /**
     * 详情-保险公司信息
     * @param insuranceCompanyBizId 保险公司唯一业务ID
     * @return
     */
    @GetMapping("/detail")
    Result<ApiInsuranceCompanyDetailResponse> detail(@NotBlank(message = "保险公司唯一业务ID不能为空") @RequestParam(value = "insuranceCompanyBizId") String insuranceCompanyBizId);

    /**
     * 添加-保险公司信息
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiInsuranceCompanyAddRequest request);

    /**
     * 编辑-保险公司信息
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiInsuranceCompanyEditRequest request);


    /**
     * 删除-保险公司信息
     * @param insuranceCompanyBizId 保险公司唯一业务ID
     * @return
     */
    @DeleteMapping("/del")
    Result del(@RequestParam(value = "insuranceCompanyBizId") String insuranceCompanyBizId);

    /**
     * 编辑-保险公司信息合作状态
     * @param insuranceCompanyBizId 保险公司唯一业务ID
     * @param cooperationStatus 合作状态（合作中、已终止、未合作）
     * @return
     */
    @PatchMapping("/edit/cooperationStatus")
    Result editStatus(@NotBlank(message = "保险公司唯一业务ID不能为空") @RequestParam(value = "insuranceCompanyBizId") String insuranceCompanyBizId,
                      @NotBlank(message = "合作状态不能为空") @RequestParam(value = "cooperationStatus") String cooperationStatus);
}
