package com.yd.insurance.base.feign.dto;

import lombok.Data;

import javax.validation.constraints.NotBlank;

@Data
public class ApiInsuranceCompanyDto {

    /**
     * 保险公司表唯一业务ID
     */
    private String insuranceCompanyBizId;

    /**
     * 部门组织表唯一业务ID
     */
    private String deptBizId;

    /**
     * 保险公司编码
     */
    private String code;

    /**
     * 保险公司全称
     */
    @NotBlank(message = "保险公司全称不能为空")
    private String fullName;

    /**
     * 保险公司简称
     */
    private String abbreviation;

    /**
     * 保险公司英文全称
     */
    private String enFullName;

    /**
     * 保险公司英文简称
     */
    private String enAbbreviation;

    /**
     * 保险公司类型（财险、寿险、健康险、综合）
     */
    private String type;

    /**
     * 所属地区
     */
    private String region;

    /**
     * 保险公司介绍（支持HTML）
     */
    private String introduction;

    /**
     * 联系电话
     */
    private String contactPhone;

    /**
     * 联系邮箱
     */
    private String contactEmail;

    /**
     * 官方网站
     */
    private String officialWebsite;

    /**
     * 公众号名称
     */
    private String officialAccountName;

    /**
     * 公众号二维码
     */
    private String officialAccountQrCode;

    /**
     * 合作状态（合作中、已终止、未合作）
     */
    private String cooperationStatus;

}
